(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     25426,        699]
NotebookOptionsPosition[     24697,        674]
NotebookOutlinePosition[     25040,        689]
CellTagsIndexPosition[     24997,        686]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"Euler", "[", 
   RowBox[{"f_", ",", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "x0_", ",", "xn_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y_", ",", "y0_"}], "}"}], ",", "steps_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"xprev", "=", "x0"}], ",", 
      RowBox[{"yprev", "=", "y0"}], ",", 
      RowBox[{"aplist", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"x0", ",", "y0"}], "}"}], "}"}]}], ",", "x", ",", "y", ",", 
      "h"}], "}"}], ",", 
    RowBox[{
     RowBox[{"h", "=", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"xn", "-", "x0"}], ")"}], "/", "steps"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"xnext", "=", 
         RowBox[{"xprev", "+", "h"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ynext", "=", 
         RowBox[{"yprev", "+", 
          RowBox[{"h", "*", 
           RowBox[{"(", 
            RowBox[{"f", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"x", "\[Rule]", "xprev"}], ",", 
               RowBox[{"y", "\[Rule]", "yprev"}]}], "}"}]}], ")"}]}]}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"aplist", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"aplist", ",", 
           RowBox[{"{", 
            RowBox[{"xnext", ",", 
             RowBox[{"NumberForm", "[", 
              RowBox[{"ynext", ",", 
               RowBox[{"{", 
                RowBox[{"15", ",", "8"}], "}"}]}], "]"}]}], "}"}]}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"xprev", "=", "xnext"}], ";", "\[IndentingNewLine]", 
        RowBox[{"yprev", "=", "ynext"}]}], ",", 
       RowBox[{"{", "steps", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"Grid", "[", "aplist", "]"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.697212411087834*^9, 3.6972124110911474`*^9}, {
  3.697213301364352*^9, 3.6972133063409276`*^9}, {3.69721686798821*^9, 
  3.6972168853530636`*^9}, {3.697217019220046*^9, 3.697217026066078*^9}, {
  3.6972173800001516`*^9, 3.6972174124702044`*^9}, {3.697225567151311*^9, 
  3.6972256386313496`*^9}, {3.69722835682576*^9, 3.697228357186286*^9}, {
  3.697246538916024*^9, 3.697246542373491*^9}, {3.6972466340822277`*^9, 
  3.6972466428051133`*^9}, {3.697252391392692*^9, 3.6972523916583633`*^9}, {
  3.697295652597535*^9, 3.697295668359868*^9}, {3.6972957020882235`*^9, 
  3.6972957026563807`*^9}, {3.697295831626071*^9, 3.6972958641546726`*^9}, {
  3.6972959578531647`*^9, 3.6972959665886374`*^9}}],

Cell[BoxData[
 RowBox[{"Euler", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"y", "^", "2"}]}], "+", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}], ",", "10"}], "]"}]], "Input",
 CellChangeTimes->{{3.6972124154206057`*^9, 3.697212418114647*^9}, {
  3.6972124841934104`*^9, 3.697212513962431*^9}, {3.697252397560076*^9, 
  3.69725239776118*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EulerGraph", "[", 
   RowBox[{"f_", ",", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "x0_", ",", "xn_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y_", ",", "y0_"}], "}"}], ",", "steps_", ",", "color_"}], "]"}],
   ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"xprev", "=", "x0"}], ",", 
      RowBox[{"yprev", "=", "y0"}], ",", 
      RowBox[{"aplist", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"x0", ",", "y0"}], "}"}], "}"}]}], ",", "x", ",", "y", ",", 
      "h"}], "}"}], ",", 
    RowBox[{
     RowBox[{"h", "=", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"xn", "-", "x0"}], ")"}], "/", "steps"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"xnext", "=", 
         RowBox[{"xprev", "+", "h"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ynext", "=", 
         RowBox[{"yprev", "+", 
          RowBox[{"h", "*", 
           RowBox[{"(", 
            RowBox[{"f", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"x", "\[Rule]", "xprev"}], ",", 
               RowBox[{"y", "\[Rule]", "yprev"}]}], "}"}]}], ")"}]}]}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"aplist", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"aplist", ",", 
           RowBox[{"{", 
            RowBox[{"xnext", ",", "ynext"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"xprev", "=", "xnext"}], ";", "\[IndentingNewLine]", 
        RowBox[{"yprev", "=", "ynext"}]}], ",", 
       RowBox[{"{", "steps", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"ListLinePlot", "[", 
       RowBox[{"aplist", ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", "color", "}"}]}]}], "]"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.697218113304553*^9, 3.6972181650084143`*^9}, {
  3.69721847140981*^9, 3.697218481913783*^9}, {3.69722107125241*^9, 
  3.6972210883345346`*^9}, {3.6972211330886264`*^9, 3.6972211376704416`*^9}, {
  3.697221289785097*^9, 3.6972212911293974`*^9}, {3.6972213307619314`*^9, 
  3.6972213653036604`*^9}, {3.697222706497281*^9, 3.6972227127270627`*^9}, {
  3.69722276896041*^9, 3.697222775281003*^9}, {3.6972298441781645`*^9, 
  3.6972298693550806`*^9}, {3.697229959571495*^9, 3.697229963776882*^9}, {
  3.6972300165764065`*^9, 3.697230024752463*^9}, {3.6972524321867423`*^9, 
  3.6972524339624043`*^9}, {3.697295678426817*^9, 3.697295715832893*^9}, {
  3.697295891521874*^9, 3.697295899010523*^9}, {3.697295968107237*^9, 
  3.6972959715029716`*^9}}],

Cell[BoxData[
 RowBox[{"EulerGraph", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"y", "^", "2"}]}], "+", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}], ",", "10", ",", "Green"}], "]"}]], "Input",
 CellChangeTimes->{{3.6972181508724537`*^9, 3.6972181514974623`*^9}, {
   3.6972214070478015`*^9, 3.697221411119689*^9}, {3.6972217456505127`*^9, 
   3.697221762384907*^9}, 3.69722278566269*^9, {3.697228378795643*^9, 
   3.6972284017151814`*^9}, {3.6972300288003225`*^9, 
   3.6972300341288543`*^9}, {3.6972524375779805`*^9, 3.6972524393924265`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImprovedEuler", "[", 
   RowBox[{"f_", ",", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "x0_", ",", "xn_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y_", ",", "y0_"}], "}"}], ",", "steps_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"xprev", "=", "x0"}], ",", 
      RowBox[{"yprev", "=", "y0"}], ",", 
      RowBox[{"aplist", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"x0", ",", "y0"}], "}"}], "}"}]}], ",", "x", ",", "y", ",", 
      "h"}], "}"}], ",", 
    RowBox[{
     RowBox[{"h", "=", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"xn", "-", "x0"}], ")"}], "/", "steps"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"xnext", "=", 
         RowBox[{"xprev", "+", "h"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k1", "=", 
         RowBox[{"f", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "->", "xprev"}], ",", 
            RowBox[{"y", "->", "yprev"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k2", "=", 
         RowBox[{"f", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "->", 
             RowBox[{"xprev", "+", "h"}]}], ",", 
            RowBox[{"y", "->", 
             RowBox[{"yprev", "+", 
              RowBox[{"h", "*", "k1"}]}]}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ynext", "=", 
         RowBox[{"yprev", "+", 
          RowBox[{"0.5", "h", "*", 
           RowBox[{"(", 
            RowBox[{"k1", "+", "k2"}], ")"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"aplist", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"aplist", ",", 
           RowBox[{"{", 
            RowBox[{"xnext", ",", 
             RowBox[{"NumberForm", "[", 
              RowBox[{"ynext", ",", 
               RowBox[{"{", 
                RowBox[{"15", ",", "8"}], "}"}]}], "]"}]}], "}"}]}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"xprev", "=", "xnext"}], ";", "\[IndentingNewLine]", 
        RowBox[{"yprev", "=", "ynext"}]}], ",", 
       RowBox[{"{", "steps", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"Grid", "[", "aplist", "]"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.697213798551379*^9, 3.6972138099253607`*^9}, {
   3.6972138604463263`*^9, 3.6972138721657495`*^9}, {3.697214726561186*^9, 
   3.6972148896217136`*^9}, {3.6972152116996517`*^9, 3.697215257329915*^9}, {
   3.6972172938391733`*^9, 3.6972173202528486`*^9}, 3.697217428047215*^9, {
   3.697228432996277*^9, 3.697228433419577*^9}, {3.6972524535722027`*^9, 
   3.697252456730435*^9}, {3.697295718579507*^9, 3.6972957484085035`*^9}, {
   3.697295906104721*^9, 3.6972959120907493`*^9}, {3.6972959722689347`*^9, 
   3.6972959755089173`*^9}}],

Cell[BoxData[
 RowBox[{"ImprovedEuler", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"y", "^", "2"}]}], "+", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}], ",", "10"}], "]"}]], "Input",
 CellChangeTimes->{{3.697215472817856*^9, 3.6972154829353733`*^9}, {
  3.6972284389453497`*^9, 3.69722843936928*^9}, {3.6972524642007236`*^9, 
  3.697252471160787*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImprovedEulerGraph", "[", 
   RowBox[{"f_", ",", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "x0_", ",", "xn_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y_", ",", "y0_"}], "}"}], ",", "steps_", ",", "color_"}], "]"}],
   ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"xprev", "=", "x0"}], ",", 
      RowBox[{"yprev", "=", "y0"}], ",", 
      RowBox[{"aplist", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"x0", ",", "y0"}], "}"}], "}"}]}], ",", "x", ",", "y", ",", 
      "h"}], "}"}], ",", 
    RowBox[{
     RowBox[{"h", "=", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"xn", "-", "x0"}], ")"}], "/", "steps"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"xnext", "=", 
         RowBox[{"xprev", "+", "h"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k1", "=", 
         RowBox[{"f", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "->", "xprev"}], ",", 
            RowBox[{"y", "->", "yprev"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k2", "=", 
         RowBox[{"f", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "->", 
             RowBox[{"xprev", "+", "h"}]}], ",", 
            RowBox[{"y", "->", 
             RowBox[{"yprev", "+", 
              RowBox[{"h", "*", "k1"}]}]}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ynext", "=", 
         RowBox[{"yprev", "+", 
          RowBox[{"0.5", "h", "*", 
           RowBox[{"(", 
            RowBox[{"k1", "+", "k2"}], ")"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"aplist", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"aplist", ",", 
           RowBox[{"{", 
            RowBox[{"xnext", ",", "ynext"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"xprev", "=", "xnext"}], ";", "\[IndentingNewLine]", 
        RowBox[{"yprev", "=", "ynext"}]}], ",", 
       RowBox[{"{", "steps", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"ListLinePlot", "[", 
       RowBox[{"aplist", ",", 
        RowBox[{"PlotStyle", "\[Rule]", "color"}]}], "]"}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.697228452196206*^9, 3.697228488381097*^9}, {
  3.6972300462173867`*^9, 3.6972300575921865`*^9}, {3.6972524803637757`*^9, 
  3.6972524846592255`*^9}, {3.6972957285471277`*^9, 3.697295759840389*^9}, {
  3.697295912976635*^9, 3.6972959184186773`*^9}, {3.6972959762744026`*^9, 
  3.6972959801047196`*^9}}],

Cell[BoxData[
 RowBox[{"ImprovedEulerGraph", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"y", "^", "2"}]}], "+", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}], ",", "10", ",", "Red"}], "]"}]], "Input",
 CellChangeTimes->{{3.697228494292379*^9, 3.697228506839512*^9}, {
  3.6972300623300066`*^9, 3.6972300640724344`*^9}, {3.697252490368966*^9, 
  3.6972524952483196`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"RungeKutta", "[", 
   RowBox[{"f_", ",", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "x0_", ",", "xn_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y_", ",", "y0_"}], "}"}], ",", "steps_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"xprev", "=", "x0"}], ",", 
      RowBox[{"yprev", "=", "y0"}], ",", 
      RowBox[{"aplist", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"x0", ",", "y0"}], "}"}], "}"}]}], ",", "x", ",", "y", ",", 
      "h"}], "}"}], ",", 
    RowBox[{
     RowBox[{"h", "=", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"xn", "-", "x0"}], ")"}], "/", "steps"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"xnext", "=", 
         RowBox[{"xprev", "+", "h"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k1", "=", 
         RowBox[{"f", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "->", "xprev"}], ",", 
            RowBox[{"y", "->", "yprev"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k2", "=", 
         RowBox[{"f", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "->", 
             RowBox[{"xprev", "+", 
              RowBox[{"0.5", "h"}]}]}], ",", 
            RowBox[{"y", "->", 
             RowBox[{"yprev", "+", 
              RowBox[{"0.5", "h", "*", "k1"}]}]}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k3", "=", 
         RowBox[{"f", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "->", 
             RowBox[{"xprev", "+", 
              RowBox[{"0.5", "h"}]}]}], ",", 
            RowBox[{"y", "->", 
             RowBox[{"yprev", "+", 
              RowBox[{"0.5", "h", "*", "k2"}]}]}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k4", "=", 
         RowBox[{"f", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "->", 
             RowBox[{"xprev", "+", "h"}]}], ",", 
            RowBox[{"y", "->", 
             RowBox[{"yprev", "+", 
              RowBox[{"h", "*", "k3"}]}]}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ynext", "=", 
         RowBox[{"yprev", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"h", "/", "6"}], ")"}], "*", 
           RowBox[{"(", 
            RowBox[{"k1", "+", 
             RowBox[{"2", "k2"}], "+", 
             RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"aplist", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"aplist", ",", 
           RowBox[{"{", 
            RowBox[{"xnext", ",", 
             RowBox[{"NumberForm", "[", 
              RowBox[{"ynext", ",", 
               RowBox[{"{", 
                RowBox[{"15", ",", "8"}], "}"}]}], "]"}]}], "}"}]}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"xprev", "=", "xnext"}], ";", "\[IndentingNewLine]", 
        RowBox[{"yprev", "=", "ynext"}]}], ",", 
       RowBox[{"{", "steps", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"Grid", "[", "aplist", "]"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6972160806672716`*^9, 3.69721618851678*^9}, {
   3.6972162622774487`*^9, 3.697216264971156*^9}, 3.697217444664898*^9, {
   3.6972525046092196`*^9, 3.6972525067860775`*^9}, {3.697295731529061*^9, 
   3.6972957320568027`*^9}, {3.6972957751860743`*^9, 
   3.6972957827324934`*^9}, {3.697295919572852*^9, 3.6972959272029505`*^9}, {
   3.6972959809910674`*^9, 3.697295984204612*^9}}],

Cell[BoxData[
 RowBox[{"RungeKutta", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"y", "^", "2"}]}], "+", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}], ",", "10"}], "]"}]], "Input",
 CellChangeTimes->{{3.6972162092418456`*^9, 3.697216212273361*^9}, {
  3.6972525123684063`*^9, 3.697252514697946*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"RungeKuttaGraph", "[", 
   RowBox[{"f_", ",", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "x0_", ",", "xn_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y_", ",", "y0_"}], "}"}], ",", "steps_", ",", "color_"}], "]"}],
   ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"xprev", "=", "x0"}], ",", 
      RowBox[{"yprev", "=", "y0"}], ",", 
      RowBox[{"aplist", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"x0", ",", "y0"}], "}"}], "}"}]}], ",", "x", ",", "y", ",", 
      "h"}], "}"}], ",", 
    RowBox[{
     RowBox[{"h", "=", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"xn", "-", "x0"}], ")"}], "/", "steps"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"xnext", "=", 
         RowBox[{"xprev", "+", "h"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k1", "=", 
         RowBox[{"f", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "->", "xprev"}], ",", 
            RowBox[{"y", "->", "yprev"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k2", "=", 
         RowBox[{"f", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "->", 
             RowBox[{"xprev", "+", 
              RowBox[{"0.5", "h"}]}]}], ",", 
            RowBox[{"y", "->", 
             RowBox[{"yprev", "+", 
              RowBox[{"0.5", "h", "*", "k1"}]}]}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k3", "=", 
         RowBox[{"f", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "->", 
             RowBox[{"xprev", "+", 
              RowBox[{"0.5", "h"}]}]}], ",", 
            RowBox[{"y", "->", 
             RowBox[{"yprev", "+", 
              RowBox[{"0.5", "h", "*", "k2"}]}]}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k4", "=", 
         RowBox[{"f", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "->", 
             RowBox[{"xprev", "+", "h"}]}], ",", 
            RowBox[{"y", "->", 
             RowBox[{"yprev", "+", 
              RowBox[{"h", "*", "k3"}]}]}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ynext", "=", 
         RowBox[{"yprev", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"h", "/", "6"}], ")"}], "*", 
           RowBox[{"(", 
            RowBox[{"k1", "+", 
             RowBox[{"2", "k2"}], "+", 
             RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"aplist", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"aplist", ",", 
           RowBox[{"{", 
            RowBox[{"xnext", ",", "ynext"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"xprev", "=", "xnext"}], ";", "\[IndentingNewLine]", 
        RowBox[{"yprev", "=", "ynext"}]}], ",", 
       RowBox[{"{", "steps", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"ListLinePlot", "[", 
       RowBox[{"aplist", ",", 
        RowBox[{"PlotStyle", "\[Rule]", "color"}]}], "]"}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.6972291783415585`*^9, 3.697229216557024*^9}, {
  3.697230069875229*^9, 3.6972300788560085`*^9}, {3.6972525217244415`*^9, 
  3.6972525264357514`*^9}, {3.697295734384243*^9, 3.6972957348804264`*^9}, {
  3.6972957912594266`*^9, 3.6972957932641935`*^9}, {3.697295823291939*^9, 
  3.6972958237783775`*^9}, {3.6972959279932733`*^9, 3.6972959883750305`*^9}}],

Cell[BoxData[
 RowBox[{"RungeKuttaGraph", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"y", "^", "2"}]}], "+", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}], ",", "10", ",", "Purple"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.69722922109669*^9, 3.697229231141071*^9}, {
  3.6972300836022606`*^9, 3.697230088001255*^9}, {3.697252531072832*^9, 
  3.6972525348575373`*^9}}],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Show", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"\[ExponentialE]", "^", 
         RowBox[{"(", 
          RowBox[{"2", "x"}], ")"}]}], "+", "x"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"EulerGraph", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "y"}], "-", 
        RowBox[{"2", "x"}], "+", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}], ",", "n", ",", "Red"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ImprovedEulerGraph", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "y"}], "-", 
        RowBox[{"2", "x"}], "+", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}], ",", "n", ",", "Purple"}], "]"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"RungeKuttaGraph", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "y"}], "-", 
        RowBox[{"2", "x"}], "+", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}], ",", "n", ",", "Pink"}], "]"}]}], 
    "\[IndentingNewLine]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "\"\<Number of Steps\>\""}], "}"}], ",", 
     "1", ",", "100", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.697229250320942*^9, 3.6972292517044334`*^9}, {
  3.697229354029035*^9, 3.6972294572942343`*^9}, {3.6972294963862705`*^9, 
  3.697229542182534*^9}, {3.6972295920782137`*^9, 3.6972296312802067`*^9}, {
  3.697230095642682*^9, 3.6972301445377626`*^9}, {3.697230196082918*^9, 
  3.6972302008265553`*^9}, {3.697231008980425*^9, 3.697231010332427*^9}, {
  3.69723107225399*^9, 3.6972310858616376`*^9}, {3.6972312750906773`*^9, 
  3.697231344424718*^9}, {3.6972313780734453`*^9, 3.6972313793174624`*^9}, {
  3.6972314743894224`*^9, 3.697231474607518*^9}, {3.6973117685196075`*^9, 
  3.697311787023608*^9}}]
},
WindowSize->{1280, 941},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
FrontEndVersion->"10.2 for Microsoft Windows (64-bit) (July 29, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 2687, 65, 152, "Input"],
Cell[3248, 87, 528, 15, 31, "Input"],
Cell[3779, 104, 2714, 66, 152, "Input"],
Cell[6496, 172, 731, 17, 31, "Input"],
Cell[7230, 191, 2967, 76, 192, "Input"],
Cell[10200, 269, 538, 15, 31, "Input"],
Cell[10741, 286, 2690, 73, 212, "Input"],
Cell[13434, 361, 556, 15, 31, "Input"],
Cell[13993, 378, 3719, 100, 232, "Input"],
Cell[17715, 480, 485, 14, 31, "Input"],
Cell[18203, 496, 3645, 99, 232, "Input"],
Cell[21851, 597, 556, 16, 31, "Input"],
Cell[22410, 615, 2283, 57, 132, "Input"]
}
]
*)

(* End of internal cache information *)
